<?php

/**
 * Vvveb
 *
 * Copyright (C) 2022  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/*
Name: Newsletter
Slug: newsletter
Category: email
Url: https://www.vvveb.com
Description: Create Newsletters that sends email or saves data in the database
Thumb: newsletter.svg
Author: givanz
Version: 0.1
Author url: https://www.vvveb.com
Settings: /admin/index.php?module=plugins/newsletter/newsletter-list
*/

use function Vvveb\__;
use Vvveb\Plugins\Newsletter\Install;
use Vvveb\System\Core\View;
use Vvveb\System\Event;

if (! defined('V_VERSION')) {
	die('Invalid request!');
}

#[\AllowDynamicProperties]
class NewsletterPlugin {
	function admin() {
		// add admin menu item
		$admin_path = \Vvveb\adminPath();

		Event::on('Vvveb\Controller\Base', 'init-menu', __CLASS__, function ($menu) use ($admin_path) {
			// add menu entry under plugins submenu
			$menu['plugins']['items']['newsletter'] = [
				'name'     => __('Newsletter'),
				'url'      => $admin_path . 'index.php?module=plugins/newsletter/newsletter-list',
				'icon'     => 'icon-newspaper-outline',
				//'icon-img' => PUBLIC_PATH . 'plugins/newsletter/newsletter.svg',
				'module'   => 'plugins/newsletter/newsletter-list',
				'action'   => 'index',
			];

			// add shortcut to messages page to top level menu
			$menuEntry = [
				'name'     => __('Newsletter'),
				'url'      => $admin_path . 'index.php?module=plugins/newsletter/newsletter-list',
				'icon'     => 'icon-newspaper-outline',
				'module'   => 'plugins/newsletter/newsletter-list',
				'action'   => 'index',
			];

			$menu['subscribers'] = $menuEntry;

			return [$menu];
		});

		// include plugin component when the page builder loads
		Event::on('Vvveb\Controller\Editor\Editor', 'loadThemeAssets', __CLASS__, function ($inputs, $components, $blocks, $sections) {
			$components['newsletter'] = '../../plugins/newsletter/editor/components.js';

			return [$inputs, $components, $blocks, $sections];
		});

		// when plugin is installed first time run install and create tables if not created
		Event::on('Vvveb\System\Extensions\Plugins', 'setup', __CLASS__, function ($pluginName, $siteId) {
			if ($pluginName == 'newsletter') {
				$this->install();
			}

			return [$pluginName, $siteId];
		});
	}

	function install() {
		$install = new Install();
		$install->run();
	}

	function app() {
		// include code Newsletters to preserve input values on form submit
		$this->view = View::getInstance();
		$template   = $this->view->getTemplateEngineInstance();
		$template->loadTemplateFile(__DIR__ . '/app/template/newsletter.tpl');
	}

	function __construct() {
		if (APP == 'admin') {
			$this->admin();
		} else {
			if (APP == 'app') {
				$this->app();
			}
		}
	}
}

$contactFormPlugin = new NewsletterPlugin();
