-- newsletter_mails

	-- Get one newsletter_mail

	CREATE PROCEDURE get(
		IN newsletter_list_id INT,
		OUT fetch_row, 
	)
	BEGIN
		-- newsletter_mail
		SELECT *
			FROM newsletter_mail as _ -- (underscore) _ means that data will be kept in main array
		WHERE newsletter_list_id = :newsletter_list_id LIMIT 1;
	END

	-- Edit newsletter_mail

	CREATE PROCEDURE edit(
		IN newsletter_mail ARRAY,
		IN newsletter_list_id INT,
		OUT affected_rows
	)
	BEGIN
		-- allow only table fields and set defaults for missing values
		@FILTER(:newsletter_mail, newsletter_mail)
		
		UPDATE newsletter_mail 
			
			SET @LIST(:newsletter_mail) 
			
		WHERE newsletter_list_id = :newsletter_list_id
	END	

	-- Add new newsletter_mail

	CREATE PROCEDURE add(
		IN newsletter_mail ARRAY,
		OUT affected_rows
	)
	BEGIN
		
		-- allow only table fields and set defaults for missing values
		:newsletter_mail  = @FILTER(:newsletter_mail, newsletter_mail)

		INSERT INTO newsletter_mail 
		
			( @KEYS(:newsletter_mail) )
			
		VALUES ( :newsletter_mail )
		ON DUPLICATE KEY UPDATE email = :newsletter_mail.email;

	END


	-- Get all newsletter_mails 

	CREATE PROCEDURE getAll(

		-- variables
		IN  language_id INT,
		IN  user_group_id INT,
		IN  site_id INT,
		IN  search CHAR,
		
		-- pagination
		IN  start INT,
		IN  limit INT,
			
		-- return array of newsletter_mails for newsletter_mails query
		OUT fetch_all,
		-- return newsletter_mails count for count query
		OUT fetch_one,
	)
	BEGIN

		SELECT * 
			FROM newsletter_mail 
		ORDER BY newsletter_list_id DESC
			
		LIMIT :limit OFFSET :start;
		
		SELECT count(*) FROM (
			
			@SQL_COUNT(newsletter_mail.newsletter_list_id, newsletter_mail) -- this takes previous query removes limit and replaces select columns with parameter product_id
			
		) as count;


	END


	-- Delete newsletter_mail

	CREATE PROCEDURE delete(
		IN  newsletter_list_id ARRAY,
		OUT affected_rows
	)
	BEGIN

		DELETE FROM newsletter_mail WHERE newsletter_list_id IN (:newsletter_list_id)
	 
	END

	-- Get number of newsletter_mails with specified status

	CREATE PROCEDURE getStatusCount(
		IN status INT,
		OUT fetch_row, 
	)
	BEGIN
		-- newsletter_mail
		SELECT count(*) as count
			FROM newsletter_mail as _ -- (underscore) _ means that data will be kept in main array
		WHERE status = :status LIMIT 1;
	END
